/*******************************************************
Filename		:  lu_station_alias.sql
Release 		:  c2.0
SIR			:  1478
Description		:  Create station alias tables and related objects.
Author			:  Joseph Wilson
Date			:  3/11/2003
Comments		:  confirm table name updates
			   06/13/03 updated v2.0
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
**********************************************************/
spool lu_station_alias.log

drop table lu_station_alias;
create table lu_station_alias 
tablespace storetdata
storage (initial 5M next 5M)
nologging
as
select tsmstatn_is_number,
	tsmstatn_org_id organization_id, 
	tsmers_is_number,
	tsmers_org_id,
	label_code station_label
from storet1.tsmrflbl;
commit;

create index isa_ers on lu_station_alias(	tsmers_is_number,	tsmers_org_id)
tablespace storetindx
storage (initial 3M next 3M)
nologging;

drop table lu_external_ref_scheme;
create table lu_external_ref_scheme nologging
tablespace storetdata
storage (initial 5M next 5M)
as
select tsmers_is_number,
	tsmers_org_id organization_id,
	acronym ref_scheme_acronym,
	name ref_scheme_name,
	description_text
from storet1.tsmers;
commit;

create index iers_ers on lu_external_ref_scheme(tsmers_is_number,organization_id)
tablespace storetindx
storage (initial 3M next 3M)
nologging;



drop sequence seq_lu_external_ref_scheme;
drop sequence seq_lu_station_alias;

create sequence seq_lu_external_ref_scheme
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create sequence seq_lu_station_alias
start with 1 increment by 1 nomaxvalue nocycle cache 10;

alter table lu_external_ref_scheme add pk_isn number;
alter table lu_station_alias add pk_isn number;
set serveroutput on
declare
cursor c1 is select rowid from lu_external_ref_scheme
order by rowid;
lv_commit_counter number:=0;
begin

for c1_var in c1 loop
update lu_external_ref_scheme
set pk_isn = seq_lu_external_ref_scheme.nextval
where rowid = c1_var.rowid;

lv_commit_counter:=lv_commit_counter+1;
if lv_commit_counter > 1000 then 
commit;
lv_commit_counter:=0;
end if;

end loop;
end;
/

commit;
set serveroutput on
declare
cursor c1 is select rowid from lu_station_alias
order by rowid;
lv_commit_counter number:=0;
begin

for c1_var in c1 loop
update lu_station_alias
set pk_isn = seq_lu_station_alias.nextval
where rowid = c1_var.rowid;

lv_commit_counter:=lv_commit_counter+1;
if lv_commit_counter > 1000 then 
commit;
lv_commit_counter:=0;
end if;

end loop;
end;
/

commit;

alter table lu_external_ref_scheme
modify pk_isn number not null;

alter table lu_station_alias
modify pk_isn number not null;

alter table lu_station_alias
add constraint pk_station_alias primary key (pk_isn)
using index
tablespace storetindx
storage (initial 3M next 3M);   

alter table lu_external_ref_scheme
add constraint pk_ref_scheme primary key (pk_isn)
using index
tablespace storetindx
storage (initial 3M next 3M);   

alter table lu_station_alias add fk_ref_scheme number(12);
alter table lu_station_alias add fk_station number(12);

--populate fk in lu_station_alias
update lu_station_alias sa set fk_ref_scheme = (
	select ers.pk_isn from lu_external_ref_scheme ers
	where ers.tsmers_is_number = sa.tsmers_is_number
	and ers.organization_id = sa.tsmers_org_id);
commit;

create bitmap index isd_location_point_type on fa_station(location_point_type)
tablespace storetindx
storage (initial 3M next 3M)
nologging;

commit;

update lu_station_alias sa set fk_station = (
	select st.pk_isn from fa_station st
	where st.station_is_number = sa.tsmstatn_is_number
	and st.organization_id = sa.organization_id
	and st.location_point_type = '*POINT OF RECORD');
commit;

--drop unused column
alter table lu_station_alias drop column tsmers_is_number;
alter table lu_station_alias drop column tsmers_org_id;
alter table lu_station_alias drop column tsmstatn_is_number;
alter table lu_station_alias drop column organization_id;
--alter table lu_external_ref_scheme drop column organization_id;
alter table lu_external_ref_scheme drop column tsmers_is_number;

--create indexes
create index statn_alias_isd_fk_station on lu_station_alias(fk_station)
tablespace storetindx
storage (initial 3m next 3m)
nologging;

create index statn_alias_isd_fk_ref_scheme on lu_station_alias(fk_ref_scheme)
tablespace storetindx
storage (initial 3m next 3m)
nologging;

--create FK constraints
alter table lu_station_alias
add constraint station_alias_fk_station foreign key (fk_station) 
references fa_station(pk_isn);

alter table lu_station_alias
add constraint station_alias_fk_ref_scheme foreign key (fk_ref_scheme) 
references lu_external_ref_scheme(pk_isn);

spool off